---
title: Rule groups · Cloudflare One docs
description: A rule group is a collection of Access rules that can be configured
  once and then quickly applied across many Access policies. Rule groups use the
  same rule types and selectors shown in the Access policy builder.
lastUpdated: 2025-10-22T21:11:06.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/cloudflare-one/access-controls/policies/groups/
  md: https://developers.cloudflare.com/cloudflare-one/access-controls/policies/groups/index.md
---

A rule group is a collection of Access rules that can be configured once and then quickly applied across many Access policies. Rule groups use the same [rule types](https://developers.cloudflare.com/cloudflare-one/access-controls/policies/#rule-types) and [selectors](https://developers.cloudflare.com/cloudflare-one/access-controls/policies/#selectors) shown in the Access policy builder.

Note

Rule groups are distinct from groups in your identity provider, like Okta groups. Rule groups can contain a mix of individual users, groups from identity providers, and service authentication options like service tokens.

## Create a rule group

To create an Access rule group:

* Dashboard

  1. In [Cloudflare One](https://one.dash.cloudflare.com), go to **Access controls** > **Policies**, and select the **Rule groups** tab.

  2. Select **Add a group**.

  3. Enter a name for the group (for example, `Lisbon-team`).

  4. Specify as many rules as needed to define your user group. For example, the following rules define a team based in Lisbon, Portugal:

     | Rule type | Selector | Value |
     | - | - | - |
     | Include | Country | `Portugal` |
     | Require | Emails Ending In | `@team.com` |

  5. Select **Save**.

* API

  Send a `POST` request to the [`/access/groups`](https://developers.cloudflare.com/api/resources/zero_trust/subresources/access/subresources/groups/methods/create/) endpoint:

  Required API token permissions

  At least one of the following [token permissions](https://developers.cloudflare.com/fundamentals/api/reference/permissions/) is required:

  * `Access: Organizations, Identity Providers, and Groups Write`

  ```bash
  curl "https://api.cloudflare.com/client/v4/accounts/$ACCOUNT_ID/access/groups" \
    --request POST \
    --header "Authorization: Bearer $CLOUDFLARE_API_TOKEN" \
    --json '{
      "name": "Lisbon-team",
      "include": [
          {
              "geo": {
                  "country_code": "PT"
              }
          }
      ],
      "exclude": [],
      "require": [
          {
              "email_domain": {
                  "domain": "team.com"
              }
          }
      ],
      "is_default": false
    }'
  ```

You can now add this group to an Access policy using the *Rule groups* selector.

## Use cases

### IP-based rules

We recommend using rule groups to define any IP address-based rules you configure in policies. Keeping IP addresses in one place allows you to modify or remove addresses once, rather than in each policy, and reduces the potential for mistakes.

Note

If adding more than one IP address or range to a rule group, use an Include rule for the IPs. If you do not use an Include rule, the policy will require traffic to originate from all ranges.

### Country requirements

You can create a rule group that consists of countries to allow or block. Access will treat the countries in the Include rule with an OR logical operator. When building policies for an Access application, you can assign this rule group to a Require policy to require at least one of the countries inside of the group. For an example policy, refer to [Require rules with OR operators](https://developers.cloudflare.com/cloudflare-one/access-controls/policies/#require-rules-with-or-operators).
