---
title: Change origin and modify paths · Cloudflare Rules docs
description: Route requests to a different origin, prepend a directory to the
  URL path, and remove specific segments.
lastUpdated: 2025-10-13T13:40:40.000Z
chatbotDeprioritize: false
tags: URL rewrite
source_url:
  html: https://developers.cloudflare.com/rules/snippets/examples/route-and-rewrite/
  md: https://developers.cloudflare.com/rules/snippets/examples/route-and-rewrite/index.md
---

This example demonstrates how to use Cloudflare Snippets to:

* Reroute incoming requests to a different origin.
* Prepend a directory to the URL path.
* Remove specific segments from the URL path.

```js
export default {
  async fetch(request) {
    // Clone the original request to create a new request object
    const newRequest = new Request(request);


    // Add a header to identify a rerouted request at the new origin
    newRequest.headers.set("X-Rerouted", "1");


    // Clone and parse the original URL
    const url = new URL(request.url);


    // Step 1: Reroute to a different origin
    url.hostname = "example.com"; // Change the hostname to the new origin


    // Step 2: Append a directory to the path
    url.pathname = `/new-path${url.pathname}`; // Prepend "/new-path" to the current path


    // Step 3: Remove a specific segment from the path
    url.pathname = url.pathname.replace("/remove-me", ""); // Rewrite `/remove-me/something` to `/something`


    // Fetch the modified request from the updated URL
    return await fetch(url, newRequest);
  },
};
```

This configuration will perform the following rewrites:

| Request URL | URL after rewrite |
| - | - |
| `https://subdomain.example.com/foo` | `https://example.com/new-path/foo` |
| `https://example.com/remove-me/bar` | `https://example.com/new-path/bar` |
| `https://example.net/remove-me` | `https://example.com/new-path` |
