---
title: Redirect requests from one domain to another · Cloudflare Rules docs
description: Create a redirect rule to redirect all requests to a different
  domain, maintaining all functionality, except for the discontinued HTTP
  service (port 80).
lastUpdated: 2025-11-07T12:30:21.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/rules/url-forwarding/examples/redirect-all-another-domain/
  md: https://developers.cloudflare.com/rules/url-forwarding/examples/redirect-all-another-domain/index.md
---

In this example the original domain was replaced with a different domain. All functionality was maintained, except for the HTTP service (port 80) which was discontinued.

[Create a redirect rule](https://developers.cloudflare.com/rules/url-forwarding/single-redirects/create-dashboard/) with the following configuration:

**When incoming requests match**

* **Wildcard pattern**
  * **Request URL**: `http*://example.com/*`

**Then**

* **Target URL**: `https://example.net/${2}`
* **Status code:** *301*
* **Preserve query string:** Enabled

This configuration will perform the following redirects:

| Request URL | URL after redirect | Status code |
| - | - | - |
| `http://example.com/` | `https://example.net/` | `301` |
| `https://example.com/` | `https://example.net/` | `301` |
| `https://example.com/my/path/to/page.htm` | `https://example.net/my/path/to/page.htm` | `301` |
| `https://example.com/search?q=term` | `https://example.net/search?q=term` | `301` |
